	T = 1; Rs = 1; RL = 1;
	N = 5; r = 0.5; 	Amax = -10*log10(1 - r^2); WcT = 0.1*pi;
	[Z0, RL, K] = RICHARDS_EQ(N, Amax, Rs, WcT, T);
	wT = 2*pi*T*[0:1000]/1000;
	W = (2/T)*tan(wT/2); 
	subplot('position', [0.08 0.4 0.90 0.5]);
	H = LADDER_2_H(N, Z0, [], [], Rs, RL, K, W, T);
	Att = MAG_2_ATT(H*2);
	plot(wT, Att,'linewidth', 2);
	axis([0, 2*pi, 0, 80]); grid on
	Z0'
	ylabel('{\itA}({\ite^j^\omega^T})  [dB]','FontName', 'Times','FontSize', 16);
	xlabel('{\it\omegaT}  [rad]','FontName', 'Times','FontSize', 16);
	set(gca,'FontName', 'Times','FontSize', 16);
	ax = [0 0.2*pi 0.4*pi 0.6*pi 0.8*pi pi 1.2*pi 1.4*pi 1.6*pi 1.8*pi 2*pi];
	lab = {'0';'0.2\pi';'0.4\pi';'0.6\pi';'0.8\pi';'\pi';'1.2\pi';'1.4\pi';'1.6\pi';'1.8\pi';'2\pi'};
	xtick(ax,lab);
	grid on;
	zoom on
	
